'QUICKFTP

' bob hanson hansonr@stolaf.edu
'
' modified 1/5/96
' to incorporate SocketWrench/VB control
' from Catalyst Software (www.earthlink.com)


'contains all global variables for the application
'and some routines
'
Global Const MB_YESNO = 4
Global Const MB_OKCANCEL = 1
Global Const MB_ICONQUESTION = 32
Global Const MB_DEFBUTTON2 = 256
Global Const ID_YES = 6
Global Const ID_OK = 1
Global Const ID_NO = 7

Global Const LogFileName = "QUICKFTP.LOG"
Global Dir_file As String, Temp_File As String

'
Global doitmode ' true for cycling login/FTP/logout
Global putmode  ' true for put file
Global cyclemode ' true if cycling

Global HostName As String
Global userid As String
Global Password As String

'
Global Connected As Integer   'flag to indicate connection
Global OkDialog As Integer    'return variable from other forms
Global inputformdata As String'return from input form
Global Success As Integer     'return variable from Ftp functions
Global Transtype As Integer   'should be Asc("A") or Asc("I")
Global DirType As Integer     'True = long; False = short
Global MaskType As String     'default = *.*  NOT IMPLEMENTED
Global Src_name As String      'source file name
Global Dest_name As String     'destination file name
Global List_Data As String     'when coming from command line option '<filename'
Global Host_File_Name As String
Global Local_File_Name As String
Global ServerDirect As String 'initial directory
Global transferaborted As Integer
Global notify As Integer
Global commandmode As Integer
Global clickindex As Integer
Global olddirclick As Integer 'for list clicking-single only
Global initialcycle As Integer
Declare Function GetTempFileName Lib "Kernel" (ByVal cDriveLetter As Integer, ByVal lpPrefixString As String, ByVal wUnique As Integer, ByVal lpTempFileName As String) As Integer
'__
'__ GLOBAL GetTempFileName
'__
'__   parameter ByVal cDriveLetter As Integer
'__   parameter ByVal lpPrefixString As String
'__   parameter ByVal wUnique As Integer
'__   parameter ByVal lpTempFileName As String
'__   called by FTP_form Form_Load
'__


Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFilename As String) As Integer
'__
'__ GLOBAL GetPrivateProfileString
'__
'__   parameter ByVal lpApplicationName As String
'__   parameter ByVal lpKeyName As Any
'__   parameter ByVal lpDefault As String
'__   parameter ByVal lpReturnedString As String
'__   parameter ByVal nSize As Integer
'__   parameter ByVal lpFilename As String
'__   called by Connectform PrivateStrings
'__


Declare Function writePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lplFileName As String) As Integer
'__
'__ GLOBAL writePrivateProfileString
'__
'__   parameter ByVal lpApplicationName As String
'__   parameter ByVal lpKeyName As Any
'__   parameter ByVal lpString As Any
'__   parameter ByVal lplFileName As String
'__   called by Connectform PrivateStrings
'__


Function DirOf (fname)
'__
'__ GLOBAL DirOf
'__
'__   parameter fname
'__
f$ = fname
DirOf = app.Path & "\"
pt = 0
For i = Len(f$) To 1 Step -1
  If Mid(f$, i, 1) = "\" Or Mid(f$, i, 1) = ":" Then pt = i: Exit For
Next i
If pt > 0 Then DirOf = Left(fname, pt)
End Function


Function Get_mask_type () As String
'__
'__ GLOBAL Get_mask_type
'__   called by FTP_form Menu_setting_items_Click
'__
  '
  Dim Answer$, DefVal, Msg, title
  '
  DefVal = MaskType
  Msg = "Enter file mask : "
  title = "File mask"
  '
  Answer = InputBox$(Msg, title, DefVal)
  '
  Get_mask_type = Answer
  '
End Function


Function getinput (prompt As String, default As String)
'__
'__ GLOBAL getinput
'__
'__   parameter prompt As String
'__   parameter default As String
'__   called by Connectform Check_info
'__   called by GLOBAL getword
'__   called by FTP_form Menu_directory_item_Click
'__
inputform.Caption = prompt
If UCase(userid) = "ANONYMOUS" And prompt = "Password" Then
  inputform.Text1.PasswordChar = ""
  inputform.Text1.Text = "YourFullEmailAddressPlease"
ElseIf default = "HIDDENVALUE" Then
  inputform.Text1.PasswordChar = "*"
  inputform.Text1.Text = ""
Else
  inputform.Text1.PasswordChar = ""
  inputform.Text1.Text = default
End If
inputform.Show 1
getinput = Trim(inputformdata)
End Function


Function getword (s, prompt As String, default As String)
'__
'__ GLOBAL getword
'__
'__   parameter s
'__   parameter prompt As String
'__   parameter default As String
'__   called by FTP_form DoConnFTPDisc
'__   called by FTP_form Form_Load
'__   calls     GLOBAL getinput
'__
 getword = " "
 s = Trim(s) & " "
 i = InStr(s, " ")
 g = Trim(Left(s, i))
 s = Trim(Mid(s, i))
 If g = "?" Then g = getinput(prompt, default)
 getword = g
End Function


Function IsDirectory (fname)
'__
'__ GLOBAL IsDirectory
'__
'__   parameter fname
'__   called by GLOBAL IsValidGet
'__
On Error Resume Next
 IsDirectory = False
 If Right(fname, 1) = "\" Then IsDirectory = True: Exit Function
 i = GetAttr(fname)
 If i And 16 Then IsDirectory = True
End Function


Function IsFile (fname)
'__
'__ GLOBAL IsFile
'__
'__   parameter fname
'__   called by GLOBAL IsValidGet
'__   called by GLOBAL IsValidPut
'__
On Error GoTo isfilenone
 IsFile = False
 i = FileLen(fname)
 If i > 0 Then IsFile = True
' unit = FreeFile
' Open fname For Input As unit: Close unit
 Exit Function
isfilenone:
 IsFile = (Err <> 53 And Err <> 76)'If file and path found (could be temporary access error)
 Exit Function
End Function


Function IsValidFile (fname)
'__
'__ GLOBAL IsValidFile
'__
'__   parameter fname
'__   called by GLOBAL IsValidGet
'__
On Error GoTo isvalidfilenot
 IsValidFile = True
 If FileLen(fname) <> 0 Then Exit Function
 unit = FreeFile
 Open fname For Output As unit: Close unit
 If FileLen(fname) = 0 Then Kill fname
 Exit Function
isvalidfilenot:
 IsValidFile = (Err = 53) Or (Err <> 53 And Err <> 76)'If file and path found (could be temporary access error)
 Exit Function

End Function


Function IsValidGet (fname)
'__
'__ GLOBAL IsValidGet
'__
'__   parameter fname
'__   called by Connectform Check_info
'__   calls     GLOBAL IsDirectory
'__   calls     GLOBAL IsFile
'__   calls     GLOBAL IsValidFile
'__
    IsValidGet = False
    If IsFile(fname) Then
      Dgdef = MB_YESNO + MB_ICONQUESTION
      yesno = MsgBox("Overwrite file " & fname & "?", Dgdef)
      If yesno = ID_NO Then Exit Function
    ElseIf Not IsValidFile(fname) Or IsDirectory(fname) Then
      MsgBox "A valid local filename is required.", 64
      Exit Function
    End If
    IsValidGet = True
End Function


Function IsValidPut (fname)
'__
'__ GLOBAL IsValidPut
'__
'__   parameter fname
'__   called by Connectform Check_info
'__   calls     GLOBAL IsFile
'__
    IsValidPut = False
    If IsFile(fname) Then
        IsValidPut = True
        Exit Function
    End If
    MsgBox "Local file " & fname & " does not exist.", 64
End Function


Sub Show_the_dir_list ()
'__
'__ GLOBAL Show_the_dir_list
'__   called by FTP_form Do_the_dirlist
'__
  'read the file and display the contents in the
  'list box
  '
  Dim Lines As Integer, FileNum As Integer
  Dim Txt As String, Ch As String * 1
  '
  FileNum = FreeFile
  Lines = 0
  '
  On Error GoTo Err_term
  Open Dir_file For Input As #FileNum
  Txt = ""
  Do While Not EOF(FileNum)
    Ch = Input$(1, #FileNum)
    If Ch <> Chr$(13) Then
      Txt = Txt & Ch
    Else
      Lines = Lines + 1
      Ftp_form!Dir_list.AddItem Txt
      Txt = ""
      Ch = Input$(1, #FileNum)  'read the linefeed
    End If
  Loop
  Close #FileNum
  '
  If Lines = 0 Then
    Txt = "No files found"
    Ftp_form!Dir_list.AddItem Txt
  End If
  Exit Sub
  '
Err_term:
  Ftp_form!Message.Caption = "Error in Dir list file"
  Exit Sub
End Sub


Sub switch_to (t As TextBox)
'__
'__ GLOBAL switch_to
'__
'__   parameter t As TextBox
'__   called by Connectform Check_info
'__   called by Connectform Form_Load
'__   called by Connectform NodeEdit_GotFocus
'__   called by Connectform NodeEdit_KeyPress
'__   called by Connectform OptDoitAll_Click
'__   called by Connectform OptFTPOnly_Click
'__   called by Connectform PasswordEdit_GotFocus
'__   called by Connectform PasswordEdit_KeyPress
'__   called by Connectform txtDirect_GotFocus
'__   called by Connectform txtDirect_KeyPress
'__   called by Connectform txtLocalFile_GotFocus
'__   called by Connectform txtLocalFile_KeyPress
'__   called by Connectform txtRemoteFile_GotFocus
'__   called by Connectform txtRemoteFile_KeyPress
'__   called by Connectform UserEdit_gotfocus
'__   called by Connectform UserEdit_KeyPress
'__   called by Get_file Form_Activate
'__   called by Get_file HostFile_KeyPress
'__   called by Get_file LocalFile_KeyPress
'__   called by Get_file txtCycle_GotFocus
'__   called by InputForm Form_Activate
'__   called by FTP_form Cycle_sec_GotFocus
'__
  t.SelStart = 0
  t.SelLength = 1000
  On Error GoTo st_cant_set
  If t.Visible Then t.SetFocus
  On Error GoTo 0
  Exit Sub
st_cant_set:
  Resume Next
End Sub


